/****************************************************************************************************/
/**
Copyright (c) 2008 Freescale Semiconductor
Freescale Confidential Proprietary
\file       Adc_Filter.c
\brief      This file performs the filtering of all ADC samples.
\author     Freescale Semiconductor
\author     Guadalajara Applications Laboratory RTAC Americas
\author     R01160
\version    0.1
\date       11/23/2008 
*/
/****************************************************************************************************/
/*                                                                                                  */
/* All software, source code, included documentation, and any implied know-how are property of      */
/* Freescale Semiconductor and therefore considered CONFIDENTIAL INFORMATION.                       */
/* This confidential information is disclosed FOR DEMONSTRATION PURPOSES ONLY.                      */
/*                                                                                                  */
/* All Confidential Information remains the property of Freescale Semiconductor and will not be     */
/* copied or reproduced without the express written permission of the Discloser, except for copies  */
/* that are absolutely necessary in order to fulfill the Purpose.                                   */
/*                                                                                                  */
/* Services performed by FREESCALE in this matter are performed AS IS and without any warranty.     */
/* CUSTOMER retains the final decision relative to the total design and functionality of the end    */
/* product.                                                                                         */
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER for the success of this project.*/
/*                                                                                                  */
/* FREESCALE disclaims all warranties, express, implied or statutory including, but not limited to, */
/* implied warranty of merchantability or fitness for a particular purpose on any hardware,         */
/* software ore advise supplied to the project by FREESCALE, and or any product resulting from      */
/* FREESCALE services.                                                                              */
/* In no event shall FREESCALE be liable for incidental or consequential damages arising out of     */
/* this agreement. CUSTOMER agrees to hold FREESCALE harmless against any and all claims demands or */
/* actions by anyone on account of any damage,or injury, whether commercial, contractual, or        */
/* tortuous, rising directly or indirectly as a result of the advise or assistance supplied CUSTOMER*/ 
/* in connectionwith product, services or goods supplied under this Agreement.                      */
/*                                                                                                  */
/****************************************************************************************************/
#include "Adc_Filter.h"
#include "AdcFltr_Test_Case.h"

/*------------- Global Variables  -----------------------------------------------------------------------*/
 int8_t i8NumberOfChannels;
 uint8_t u8Avg_Channel_Number;
 uint8_t u8SampleCntr;
 tAdcFltr_FilterStruct *AdcFltrCntl_t;

	 
/*-------------------------------------------------------------------------------------------------------*/
/**
 * \brief    This functions serves to start sampling of all configured ADC Channels and \n
 *           to keep track of which channel need to be triggered.
 * \author   R01160
 * \param    none
 * \return   none
 * \warning  This function shall be handled only by a PIT channel.
 */  
void vfnAdc_Sample_Acquire(void)
{
   uint32_t u32Temporal_cqueue[4];
   /*---------------------------- SECTION 1: Load ADC Command Queues ------------------------------------*/
   /* Saves ADC Commands into command queues 0-3 (cQUEUE0-3)  */
   if(i8NumberOfChannels == (-1))
   {
   	 AVERAGE_RELOAD_SAMPLE_BUFFER();    /* Reload the counter of Number of ADC Channels and invoke Filter Average function */							       
   	 return;
   }
     cQUEUE[0] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[0] with cmd and Adc channel */
       u32Temporal_cqueue[0] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[0] with cmd and Adc channel */;
       i8NumberOfChannels--;
         	
         	if(i8NumberOfChannels == (-1)) 
         	{
         	  AVERAGE_RELOAD_SAMPLE_BUFFER();	/* Reload the counter of Number of ADC Channels and invoke Filter Average function */				       
         	  return;
         	}
			   cQUEUE[1] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8); /* Load cQUEUE[1] with cmd and Adc channel */
			     u32Temporal_cqueue[1] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[0] with cmd and Adc channel */;
			     i8NumberOfChannels--;
			     
			         if(i8NumberOfChannels == (-1)) 
			         {
			           AVERAGE_RELOAD_SAMPLE_BUFFER();   /* Reload the counter of Number of ADC Channels and invoke Filter Average function */	  
			           return;
			         }
				       cQUEUE[2] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8); /* Load cQUEUE[2] with cmd and Adc channel */
				         u32Temporal_cqueue[2] = (uint32_t)au32Adc_Conversion_Params[ADC_ASSIGNED_CNTRL_CMD] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[0] with cmd and Adc channel */;
				         i8NumberOfChannels--;  
				         
				            if(i8NumberOfChannels == (-1)) 
				            {
				              AVERAGE_RELOAD_SAMPLE_BUFFER();   /* Reload the counter of Number of ADC Channels and invoke Filter Average function */	
				              return;
				            }
						     cQUEUE[3] = (uint32_t)au32Adc_Conversion_Params[ADC_CNTRL_CMD_WITH_EOQ] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[3] with cmd and Adc channel */
						       u32Temporal_cqueue[3] = (uint32_t)au32Adc_Conversion_Params[ADC_CNTRL_CMD_WITH_EOQ] | (uint32_t)(u16AdcChannel_Convert[ATDFLTR_0_AVERAGECHANNELS - (i8NumberOfChannels + 1)] << 8);  /* Load cQUEUE[0] with cmd and Adc channel */;
						       i8NumberOfChannels--;
						       
  /*------------------------------- SECTION 2: Trigger eDMA and Start Saving Samples ------------------------------------*/
  
   ADC_CONVERT_AND_READ_EDMA_FLG();    	/* Trigger eDMA */
   vfnAdc_Average((tAdcFltr_FilterStruct*)AdcFltrCntl_t);
				         
				         
}
/*-------------------------------------------------------------------------------------------------------------------*/
/**
 * \brief    Saves the sample acquired from an specific ADC Channel and Compute the Filter at the end of the sample \n
 *           acquisition.
 * \author   R01160
 * \param    ADC Filter Strucutre. (tAdcFltr_FilterStruct)
 * \return   none
 * \warning  
 */  
void vfnAdc_Average(tAdcFltr_FilterStruct* filter)
{
  uint8_t   u8CyclicCntr;                 /* Keeps the track of which rQUEUE buffer will be assigned to each ADC Channel */
  uint16_t  u16ChannelCntr;               /* Keeps track of current ADC Channel in execution                             */
  uint16_t  u16numTAPS;                   /* Number of samples to be averaged                                            */
  uint16_t  u16TotalAccumResult[10];
  vuint16_t vu16testresult;
  uint16_t* pu16sampleBuffer;             /* Serves to save samples from different ADC channels. Each channel has their own buffer */
  tAdcFltr_ChannelStruct* ptrchannel = NULL_PTR;
  uint16_t  u16TestAccum;
  
  u16numTAPS = filter->config.numTAPS;    /* Indicate number of samples to be averaged                 */
  ptrchannel = filter->channels;          /* Initialize local pointer with all configured ADC Channels */
  u16TestAccum = 0;
  
	 if(u8SampleCntr < u16numTAPS)     /* Maximum Sample Average reached? */
	 {
         
        for(u8CyclicCntr = 4; u8CyclicCntr > 0; u8CyclicCntr-- )
        {
          if(u8Avg_Channel_Number >= ATDFLTR_0_AVERAGECHANNELS)                   /* Does driver went through all ADC Channels? */
	      {
	        u8Avg_Channel_Number = 0;	                                          /* Reset ADC Channel counter                  */
	        return;
	      }
          pu16sampleBuffer = ptrchannel[u8Avg_Channel_Number].pSampleBuffer;	                          /* Get position in buffer                                                      */
	      pu16sampleBuffer[u8SampleCntr] = (uint16_t)((uint16_t)(*(uint16_t*)ptrchannel[u8Avg_Channel_Number].pResultRegister) >> (uint16_t)2);  /* Move value in ATD result register to buffer - values saved in reverse order */
	      ptrchannel[u8Avg_Channel_Number].u16AccumulateSample = (uint16_t)((uint16_t)pu16sampleBuffer[u8SampleCntr] + (uint16_t)ptrchannel[u8Avg_Channel_Number].u16AccumulateSample);
	      u16TestAccum = ptrchannel[u8Avg_Channel_Number].u16AccumulateSample;
	      vu16testresult = (uint16_t)pu16sampleBuffer[u8SampleCntr]; 
	      u8Avg_Channel_Number++;	                                             /* Point to next ADC Channel                   */        	
        } 
        u8SampleCntr++;
	 }
	 else   /* Compute Filter */
	 {
	   /* For each channel: Calculate the total sample averaging */
	   for(u16ChannelCntr = 0; u16ChannelCntr <= (filter->config.numChannels - 1); u16ChannelCntr++)
	   {
	   	 u16TotalAccumResult[u16ChannelCntr] = (uint16_t)((uint16_t)ptrchannel[u16ChannelCntr].u16AccumulateSample >> (uint16_t)SAMPLE_AVERAGE_VALUE);
	 	 *ptrchannel[u16ChannelCntr].pFilterResult = (uint16_t)u16TotalAccumResult[u16ChannelCntr];  /* Update result - no semaphore, CPU must use external synchronisation */
	     ptrchannel[u16ChannelCntr].u16AccumulateSample = 0;
	   } 
	 
	  u8SampleCntr = 0;                                                 /* Reset sample buffer counter  */
	  if (filter->config.interruptCPU) filter->config.AverageEndFnc();  /* Jump into End Average Interrupt function */
	 }
}

/*-------------------------------------------------------------------------------------------------------------------*/
/**
 * \brief    Initialize ADC Filter structure by configuring all ADC conversion channels \n
 *           and control variables
 * \author   R01160
 * \param    ADC Filter Strucutre. (tAdcFltr_FilterStruct)
 * \return   none
 */  
 void vfnAdcFltr_Init(tAdcFltr_FilterStruct* filter)
{
  #if (ADC_FLTR_ERROR_DETECT == ON)       
	  if (filter == NULL_PTR)        /* Adc Filter already initilized?             */     
	  {
	    vfnAdc_Filter_Report_Error(ADC_FLTR_CALLBACK_PTR_ID,ADC_FLTR_E_FNC_CALLBACK_UNINIT); /* Report None initilized module */
	  }      
	  else if((SAMPLE_AVERAGE_VALUE != _2_SAMPLE_DEPTH_)  && (SAMPLE_AVERAGE_VALUE != _4_SAMPLE_DEPTH_)  && (SAMPLE_AVERAGE_VALUE != _8_SAMPLE_DEPTH_)  \
	       && (SAMPLE_AVERAGE_VALUE != _16_SAMPLE_DEPTH_) && (SAMPLE_AVERAGE_VALUE != _32_SAMPLE_DEPTH_) && (SAMPLE_AVERAGE_VALUE != _64_SAMPLE_DEPTH_))       /* Pwm module already initilized?             */     
	 {
	    vfnAdc_Filter_Report_Error(ADC_FLTR_INIT_ID,ADC_FLTR_E_AVERAGE); /* Wrong Average parameter. Cannot average using samples outside of: 2,4,8,16,32 & 64 */
	 }      
	 else
	 {
 #endif 
   
    tAdcFltr_ChannelStruct* ptrchannel = NULL_PTR;                                                  /* Local ADC Channel pointer used to initialize Filter params */
    uint16_t u16Adc_Channel_Cntr;                                                                   /* Keeps track of the current ADC Channel                     */
    uint16_t u16Adc_Result_Cntr;                                                                    /* Used to assign ADC buffer to Filter result register        */
    
    i8NumberOfChannels    = (ATDFLTR_0_AVERAGECHANNELS - 1);
    u8Avg_Channel_Number  = 0;
    u16Adc_Result_Cntr    = 0;
   
    ptrchannel    = filter->channels;                                                               /* Initialize local pointer with ADC Configuration structure */
        
    for(u16Adc_Channel_Cntr = 0; u16Adc_Channel_Cntr < filter->config.numChannels; u16Adc_Channel_Cntr++)
    {
      
      if(u16Adc_Result_Cntr > RQUEUE_BUFF_DEPTH)                                                     /* rQUEUE reach the end ?                           */
      {
      	u16Adc_Result_Cntr = 0;                                                                      /* go back to rQUEUE number 0                       */
      }
      ptrchannel[u16Adc_Channel_Cntr].pResultRegister = &rQUEUE0[u16Adc_Result_Cntr];                /* Assign rQUEUE buffer to ADC Channel result field */
      u16Adc_Result_Cntr++;                                                                          /* Point to next ADC Channel                        */
      
      
      ptrchannel[u16Adc_Channel_Cntr].pSampleBuffer   = &atdfltr_0_channel[u16Adc_Channel_Cntr][ATDFLTR_0_AVERAGETAPS + 1]; /* Initialize sample buffer from all channels */
      ptrchannel[u16Adc_Channel_Cntr].pFilterResult   = &atdfltr_0_FilterResults[u16Adc_Channel_Cntr];                      /* Assign Filters to Adc Average channels     */
    }
    
 #if (ADC_FLTR_ERROR_DETECT == ON)      
   }
 #endif 	
}


/****************************************************************************************/
/**
 * \brief     Start ADC Averaging on every configured channels.
 * \author    R01160
 * \param     none
 * \return    none
 */  
void vfnADC_Start_Average(void)
{
	
}

/****************************************************************************************/
/**
 * \brief     Stops ADC averaging on the whole driver.
 * \author    R01160
 * \param     none
 * \return    none
 */  
void vfnADC_Stop_Average(void)
{
	
}
void vfnFilter_1_End_TC_8(void)
{
  uint16_t u16Total[4];
  
   u16Total[0] = *(uint16_t*)AdcFltrCntl_t->channels[0].pFilterResult;	
   u16Total[1] = *(uint16_t*)AdcFltrCntl_t->channels[1].pFilterResult;	
   u16Total[2] = *(uint16_t*)AdcFltrCntl_t->channels[2].pFilterResult;	
   u16Total[3] = *(uint16_t*)AdcFltrCntl_t->channels[3].pFilterResult;
  	
}
void vfnFilter_1_End(void)
{
  
   #if(ADCFLTR_TC006 == ON)
    uint16_t u16Total[2];
  
     u16Total[0] = *(uint16_t*)AdcFltrCntl_t->channels[0].pFilterResult;	
     u16Total[1] = *(uint16_t*)AdcFltrCntl_t->channels[1].pFilterResult;	  
   #endif
  
  
  
  #if((ADCFLTR_TC005 == ON) || (ADCFLTR_TC008 == ON))
   uint16_t u16Total[4];
  
   u16Total[0] = *(uint16_t*)AdcFltrCntl_t->channels[0].pFilterResult;	
   u16Total[1] = *(uint16_t*)AdcFltrCntl_t->channels[1].pFilterResult;	
   u16Total[2] = *(uint16_t*)AdcFltrCntl_t->channels[2].pFilterResult;	
   u16Total[3] = *(uint16_t*)AdcFltrCntl_t->channels[3].pFilterResult;
  
  #endif

  #if(ADCFLTR_TC007 == ON)
   
   uint16_t u16Total[6];
  
  u16Total[0] = *(uint16_t*)AdcFltrCntl_t->channels[0].pFilterResult;	
  u16Total[1] = *(uint16_t*)AdcFltrCntl_t->channels[1].pFilterResult;	
  u16Total[2] = *(uint16_t*)AdcFltrCntl_t->channels[2].pFilterResult;	
  u16Total[3] = *(uint16_t*)AdcFltrCntl_t->channels[3].pFilterResult;
  u16Total[4] = *(uint16_t*)AdcFltrCntl_t->channels[4].pFilterResult;	
  u16Total[5] = *(uint16_t*)AdcFltrCntl_t->channels[5].pFilterResult; 
  
  #endif		
}

/* End of File */